% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_parse.R
\name{smooth_parse}
\alias{smooth_parse}
\title{Transform Data to be Used in \code{smooth_algorithm()} Function}
\usage{
smooth_parse(
  id,
  start_date,
  end_date,
  drug,
  study_from = min(start_date),
  study_to = max(end_date)
)
}
\arguments{
\item{id}{Unique identifier of the patient.}

\item{start_date}{Start date of the treatment.}

\item{end_date}{End date of the treatment.}

\item{drug}{Name of the drug used.}

\item{study_from}{A date indicating when the study start.}

\item{study_to}{A date indicating when the study finish.}
}
\value{
A data.frame with the following structure:

\describe{
\item{id}{Unique identifier of the patient.}
\item{drug}{Name of the drug used.}
\item{day}{Day of the treatment.}
\item{N}{Number of drugs used in the treatment}
}
}
\description{
This function transforms the data to obtain the daily treatment.
}
\examples{
library(smoothy)
library(dplyr)

data(drugstreatment)

df <- drugstreatment |>
  filter(id == "01f13c15-d9f1-4106-a04f-976c457edd0a")

structured_df <- smooth_parse(
  id = df$id,
  start_date = df$start_date,
  end_date = df$end_date,
  drug = df$drug,
  study_from = "1970-01-01",
  study_to = "1975-01-01"
)

head(structured_df)

}
