% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_smos.R
\name{download_smos}
\alias{download_smos}
\title{Download BEC-SMOS soil moisture data}
\usage{
download_smos(data, dir = NULL)
}
\arguments{
\item{data}{a character vector as produced by \code{find_smos()} containing
external links to the data files on the BEC server.}

\item{dir}{a character string specifying a path to a local directory in which
to save the data. Default value is \code{NULL} meaning that the dataset is
stored in a temporary directory of the current R session.}
}
\value{
downloaded files in the specified directory
}
\description{
This function automates downloading of BEC-SMOS soil moisture data to a local
computer via a secure FTP (SFTP) server.
}
\details{
This function downloads the original BEC-SMOS soil moisture data in NetCDF
format ("as is") via a secure FTP (SFTP) server. The data files are stored on
the local computer in a temporary directory of the current R session (default
option) if no otherwise specified by the user.

Note that the registration as a user on the Barcelona Expert Center (BEC)
webpage is required to access the server. See
\code{\link[=set_credentials]{set_credentials()}} for details.
}
\examples{
\dontrun{
# to download files found with find_smos() into a temporary directory of the current R session
start_date <- as.Date("2022-01-01")
end_date <- as.Date("2022-12-31")
date_range <- seq(start_date, end_date, by = 30)
smos_data <- find_smos(freq = 3, orbit = "des", dates = date_range)
download_smos(smos_data)
}

}
\references{
Pablos M, Gonzalez-Haro C, Portal G, Piles M, Vall-llossera M,
Portabella M (2022). SMOS L4 Surface Soil Moisture downscaled maps at 1 km
EASE-2 (reprocessed mode) (V.6.0) [Dataset].
}
