% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSTD.R
\name{SSTD_R1}
\alias{SSTD_R1}
\title{Sparse Symmetric Tensor Decomposition (SSTD)}
\usage{
SSTD_R1(
  T_obs,
  u_ini,
  v_ini,
  max_iter = 20,
  sumabs = 0.5,
  niter = 20,
  rho = 1000,
  tol = 10^(-3),
  verbose = FALSE
)
}
\arguments{
\item{T_obs}{array, a p-by-p-by-q tensor; each p-by-p layer in \code{T_obs} should be symmetric}

\item{u_ini}{vector, with length q; the random initialization for loading vector}

\item{v_ini}{vector, with length p; the random initialization for tensor eigenvector}

\item{max_iter}{integer, the maximal iteration number}

\item{sumabs}{number, the number specify the sparsity level in the matrix/tensor eigenvector; \code{sumabs} takes value between \eqn{1/sqrt(p)} and 1, where \eqn{p} is the dimension; \code{sumabs}\eqn{*sqrt(p)} is the upperbound of the L1 norm of the leading matrix/tensor eigenvector (see \code{symmPMD()})}

\item{niter}{integer, the number of iterations to use in the PMD algorithm (see \code{symmPMD()})}

\item{rho}{number, a large positive constant adding to the diagonal elements to ensure positive definiteness in symmetric matrix spectral decomposition}

\item{tol}{number, the tolerance threshold for SSTD convergence; if the error difference between two iterations is smaller than \code{tol}, then we stop the iteration and consider the algorithm converges}

\item{verbose}{logic variable, whether to print the progress during permutation tests}
}
\value{
a list containing the following:

\item{u_hat}{vector, with length q; the estimated loading vector}

\item{v_hat}{vector, with length p; the estimated tensor eigenvector}

\item{gamma_hat}{number, the estimated sLTE \eqn{\Lambda}}
}
\description{
SSTD solves the rank-1 approximation to the a p-by-p-by-q sparse symmetric tensor \eqn{\mathcal{D}}:
\deqn{ \min_{\Lambda, v, u} ||\mathcal{D} - \Lambda v \circ v \circ u||_F^2}
subject to
\deqn{ \Lambda > 0, v \in R^p, u \in R^q, ||v||_2 = ||u||_2 = 1, ||v||_0 <= R}

The solution \eqn{\Lambda} is the sparse leading tensor eigenvalue (sLTE),
\eqn{v} is the sparse leading tensor eigenvector, and \eqn{u} is the loading vector.

The Symmetric Penalized Matrix Decomposition \code{symmPMD()} is used in the iterative algorithm.
}
\references{
Hu, J., Weber, J. N., Fuess, L. E., Steinel, N. C., Bolnick, D. I., & Wang, M. (2025). A spectral framework to map QTLs affecting joint differential networks of gene co-expression. PLOS Computational Biology, 21(4), e1012953.

Sun, W. W., Lu, J., Liu, H., & Cheng, G. (2017). "Provable sparse tensor decomposition."
Journal of the Royal Statistical Society Series B: Statistical Methodology, 79(3), 899-916.
}
\seealso{
\code{symmPMD()}
}
