% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_class.R
\docType{class}
\name{Tensor-class}
\alias{Tensor-class}
\alias{Tensor}
\title{S4 Class for a Tensor}
\description{
An S4 class for a tensor with arbitrary number of modes. The Tensor class extends the base "array" class to include additional tensor manipulation (folding, unfolding, reshaping, subsetting) as well as a formal class definition that enables more explicit tensor algebra.
}
\note{
All of the decompositions and regression models in this package require a Tensor input.
}
\section{Slots}{

\describe{
\item{num_modes}{number of modes (integer)}
\item{modes}{vector of modes (integer), aka sizes/extents/dimensions}
\item{data}{actual data of the tensor, which can be 'array' or 'vector'}
}
}

\references{
James Li, Jacob Bien, Martin T. Wells (2018). rTensor: An R Package for Multidimensional Array (Tensor) Unfolding, Multiplication, and Decomposition. Journal of Statistical Software, Vol. 87, No. 10, 1-31. URL: http://www.jstatsoft.org/v087/i10/.
}
\seealso{
\code{\link{as.tensor}}
}
\author{
James Li \email{jamesyili@gmail.com}
}
