% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_methods.R
\name{as.vector.sk}
\alias{as.vector.sk}
\title{Convert grid data to vector of specified mode}
\usage{
\method{as.vector}{sk}(x, mode = "any")
}
\arguments{
\item{x}{a sk object}

\item{mode}{passed to as.vector}
}
\value{
a vector of the specified mode
}
\description{
Returns a vector of the specified mode, representing the vectorized grid data.
For multi-layer \code{x}, the first layer is returned.
}
\details{
For single layer \code{x}, and with default \code{mode='any'}, this is the same as \code{x[]}
}
\examples{
g = sk_validate(list(gval=stats::rnorm(4^2), gdim=4, gres=0.5))
as.vector(g)
}
