% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_index.R
\name{sk_mat2vec}
\alias{sk_mat2vec}
\title{Column-vectorization indices}
\usage{
sk_mat2vec(ij, gdim, simplified = TRUE)
}
\arguments{
\item{ij}{n x 2 matrix, the row and column indices}

\item{gdim}{integer (or vector with first element equal to) the number of rows in the matrix}

\item{simplified, }{if FALSE, the function returns an n x 1 matrix}
}
\value{
integer vector, the vectorized \code{ij} indices
}
\description{
Maps matrix indices i, j to a single vectorized index, k
}
\details{
Column vectorization (as in \code{base::as.vector}) builds a length(mn) vector by stacking
the columns of an m X n matrix, with the leftmost column appearing first in the vector
and the rightmost column last. Matrix element i,j gets mapped to element k = i + m * (j-1)
in the vector. This function returns that index.

\code{ij} can be a matrix or a list of length-n vectors 'i' and 'j', or a vector
representing a single point at the given row (i) and column (j) number (in that order).

\code{gdim} should either be an integer number of rows in the matrix, or a vector of the form
\code{c(ni, nj)} (the return value of \code{dim} for example) in which case its first element is used.
}
\examples{
# define matrix dimensions and look up a specific index
gdim = c(4, 5)
ij = c(i=3, j=2)
sk_mat2vec(ij, gdim)

# display all matrix indices in column-vectorized order
gyx = expand.grid(i=seq(gdim[1]), j=seq(gdim[2]))
result = sk_mat2vec(gyx, gdim)
data.frame(k=result, gyx)

}
\seealso{
Other indexing functions: 
\code{\link{sk_rescale}()},
\code{\link{sk_sub_find}()},
\code{\link{sk_sub_idx}()},
\code{\link{sk_vec2mat}()}
}
\concept{indexing functions}
\keyword{internal}
