% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_about_one_seed.R
\name{sample_about_one_seed}
\alias{sample_about_one_seed}
\title{Snowball Sampling with Multiple Inclusions around One Network Node}
\usage{
sample_about_one_seed(net, seed, n.wave = 1)
}
\arguments{
\item{net}{a network object that is a list containing:
\describe{
  \item{\code{degree}}{the degree sequence of the network, which is
     an \code{integer} vector of length \eqn{n};}
  \item{\code{edges}}{the edgelist, which is a two-column
     matrix, where each row is an edge of the network;}
  \item{\code{n}}{the network order (i.e., number of nodes in the network).}
}
The network object can be simulated by \code{\link{random_network}},
selected from the networks available in \code{\link{artificial_networks}},
converged from an \code{igraph} object with \code{\link{igraph_to_network}},
etc.}

\item{seed}{numeric ID of a seed to start the LSMI.}

\item{n.wave}{an integer defining the number of waves (order of the neighborhood)
to be recorded around the seed in the LSMI. For example, \code{n.wave = 1} corresponds to
an LSMI with the seed and its first neighbors. Note that the algorithm allows for
multiple inclusions.}
}
\value{
\code{sample_about_one_seed} returns a list of length \code{n.wave + 1}
containing ID of the seed (1st element of the output list), IDs of nodes in the
1st wave (2nd element of the list), \ldots, IDs of nodes in the wave \code{n.wave}
((\code{n.wave + 1})th element of the list). If a wave has no nodes in it, the
corresponding element of the output contains \code{NA}.
}
\description{
This function obtains a labeled snowball with multiple inclusions (LSMI) sample,
starting from a single network node called seed. See Figure 1 by
\insertCite{thompson_etal_2016;textual}{snowboot} illustrating the algorithm
of sampling around one seed.
}
\examples{
net <- artificial_networks[[1]]
a <- sample_about_one_seed(net, seed = 1, n.wave = 2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{lsmi}}
}
