% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{snowflake_credentials}
\alias{snowflake_credentials}
\title{Get credentials for a Snowflake connection}
\usage{
snowflake_credentials(params, role = NULL, spcs_endpoint = NULL, ...)
}
\arguments{
\item{params}{a list of connection parameters from `\code{\link[=snowflake_connection]{snowflake_connection()}}``}

\item{role}{a snowflake entity}

\item{spcs_endpoint}{a Snowpark Container Services ingress URL, formatted (*-accountname.snowflakecomputing.app)}

\item{...}{Additional Snowflake connection parameters}
}
\value{
A list of HTTP headers.
}
\description{
Get credentials for a Snowflake connection
}
\examples{
\dontshow{if (has_a_default_connection()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Obtain authentication headers for accessing Snowflake APIs
snowflake_credentials(
 snowflake_connection()
)
\dontshow{\}) # examplesIf}
\dontshow{if (has_a_default_connection()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# If the application is in Snowpark Container Services,
# a different collection of headers are returned:
snowflake_credentials(
 snowflake_connection(),
 spcs_endpoint = "https://example-accountname.snowflakecomputing.app"
)
\dontshow{\}) # examplesIf}
}
