% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_build_plot.r
\name{add.ellipse}
\alias{add.ellipse}
\title{Add a layer with concentration ellipses to an mca map.}
\usage{
add.ellipse(
  object,
  var = NULL,
  draw = unique(var),
  dim = c(1, 2),
  el = ellipses(object, var = var, dim = dim),
  mapping = aes(color = Category),
  draw.axis = TRUE,
  ...
)
}
\arguments{
\item{object}{a soc.mca result object}

\item{var}{a factor}

\item{draw}{a character vector with the levels to draw ellipses for}

\item{dim}{a numeric vector with the dimensions for the plane}

\item{el}{a data.frame produced by the \link{ellipses} function.}

\item{mapping}{a call to \link[ggplot2]{aes} from the ggplot2 package. Here you can map aesthetics to variables such as color, fill, alpha, size and linetype.}

\item{draw.axis}{if TRUE the axis within the concentration ellipse is drawn.}

\item{...}{further arguments is passed onto \link[ggplot2]{geom_path} and \link[ggplot2]{geom_line}}
}
\value{
a ggplot2 object that can be added to an existing plot like those produced by \link{map.ca.base}
}
\description{
Add a layer with concentration ellipses to an mca map.
}
\examples{
example(soc.mca)
map.ca.base() + add.ind(result, mapping = aes(color = sup$Gender)) +
                  add.ellipse(result, sup$Gender)
map.ca.base() + add.ind(result, mapping = aes(color = sup$Age == "65+")) +
                          add.ellipse(result, sup$Age == "65+", draw = "TRUE")
}
