% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comtrosp.R
\name{comtrosp}
\alias{comtrosp}
\title{A function to combine trophic species.}
\usage{
comtrosp(
  usin,
  selected = NA,
  deleteCOMBOcannibal = FALSE,
  allFEEDING1 = FALSE,
  newname = NA
)
}
\arguments{
\item{usin}{The community were you are combining trophic species}

\item{selected}{Select trophic species to combine, which ones do you want to combine (vector of names)? If left as NA, the two most similar trophic species are combined. Similarity is determined by shared feeding relationships.}

\item{deleteCOMBOcannibal}{Boolean: Do you want to delete the cannibalism that may have been created by combining two trophic species (TRUE) or leave it in the model (FALSE)?}

\item{allFEEDING1}{Boolean: Do you want to return all feeding preferences to 1 (TRUE), or would you like to set the feeding preferences of the newly combined trophic species as the biomass-weighted average of the old ones (FALSE)?}

\item{newname}{The name you want to use for the combined trophic species. Default replaces combines the names of the original trophic species divided by "/".}
}
\value{
The new community with the seltf or most similar trophic species combined.
}
\description{
A function to combine trophic species.
}
\details{
The function combines trophic species by merging them in both the community matrix (imat) and the properties database (prop). The user can select the two or more trophic species to be combined using the selected option. If this is left as the default (NA), then the two most similar trophic species are combined by comparing their feeding relationships.
}
\examples{
# Combine two trophic species that are the most similar.
comtrosp(intro_comm)

# Combine two selected trophic species.
comtrosp(intro_comm, selected = c("Orib1", "Predator"))

# Combine two selected trophic species
# Remove the cannibalism that is created
# Rescale all feeding preferences to 1.
comtrosp(intro_comm,
selected = c("Orib1", "Predator"),
deleteCOMBOcannibal = TRUE,
allFEEDING1 = TRUE)
}
