% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPARAMS.R
\name{getPARAMS}
\alias{getPARAMS}
\title{A function to get the parameters for a food web model.}
\usage{
getPARAMS(
  usin,
  DIETLIMTS = NA,
  diet_correct = TRUE,
  Conly = FALSE,
  userdefinedinputs = NA,
  returnCNmin = FALSE,
  has_inorganic_nitrogen = FALSE,
  densitydependence = NA,
  inorganic_nitrogen_properties = list(INN = NA, q = NA, eqmN = NA),
  verbose = TRUE,
  Immbolizationlimit = Inf
)
}
\arguments{
\item{usin}{The community you want to simulate.}

\item{DIETLIMTS}{The diet limits matrix for the stoichiometry correction (proportion of diet)?}

\item{diet_correct}{Boolean: Does the organism correct it's diet?}

\item{Conly}{Boolean: Is the model meant for carbon only?}

\item{userdefinedinputs}{Do you want to input a user defined vector of input functions? If NA the input values that keep the system at equilibrium are calculated. If not, put in a vector of input rates for each node.}

\item{returnCNmin}{Boolean: Do you want to add Cmin and Nmin to the list of the results? Used internally in the package in \code{\link{calculate_inputs}}.}

\item{has_inorganic_nitrogen}{Boolean: Is there an inorganic nitrogen pool?}

\item{densitydependence}{Which nodes have density dependence? NA default means none of them do. Should be a vector of 0 (no DD) and 1 (DD) for each node.}

\item{inorganic_nitrogen_properties}{A list of state variables for the inorganic nitrogen pool (INN = inputs, q = per capita loss of N, eqmN = equilibrium N). Must include a value for two of the three variables and has the final one as NA.}

\item{verbose}{Boolean: Do you want extra warnings updates?}

\item{Immbolizationlimit}{This is the limit of the amount of nitrogen the food web can immobilize nitrogen (NOT PLANTS). This will impact the calculations of inorganic nitrogen dynamics.}
}
\value{
A list with two elements: (1) a vector of parameters to run the model away from equilibrium and (2) a vector of starting biomasses.
}
\description{
A function to get the parameters for a food web model.
}
\details{
A function to get the parameters of a food web model for simulation purposes. It does not correct stoichiometry, so the user must do this beforehand if they want.
}
\examples{
# Basic call.
getPARAMS(intro_comm)
}
\seealso{
\code{\link{CNsim}}, \code{\link{stability2}}, and \code{\link{calculate_inputs}} for the application of the function and use of it's options.
}
