% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spDates.R
\name{iterateSites}
\alias{iterateSites}
\title{Perform regression of dates versus distances from multiple potential origins
in order to find the best model. It is also possible to specify multiple
distances for the spatial binning of the dates.}
\usage{
iterateSites(
  ftrSites,
  c14bp,
  origins,
  siteNames,
  binWidths = 0,
  nsim = 999,
  method = "rma",
  ncores = 1
)
}
\arguments{
\item{ftrSites}{A SpatialPointsDataFrame object with associated earliest
C14 dates per site and respective calibrated distributions (CalDates
objects) in a field named "cal".}

\item{c14bp}{A string. Name of the field with the radiocarbon ages in C14
BP format.}

\item{origins}{A SpatialPointsDataFrame object. The sites to be tested for
the most likely origin of expansion.}

\item{siteNames}{A string. Name of the field with the site names or ids for
the potential origins.}

\item{binWidths}{A number or vector of numbers. Width(s) of the spatial bins
in km.}

\item{nsim}{A number. Number of simulations to be run during the
bootstrapping procedure. Default is 999.}

\item{method}{A string. Method to be used in the regression. One of "rma"
or "ols". Default is "rma".}

\item{ncores}{A number. Number of cores used for parallel processing.
Default is 1.}
}
\value{
a list with two elements, the result of the iteration over all
potential origins and the best model selected among those.
}
\description{
Perform regression of dates versus distances from multiple potential origins
in order to find the best model. It is also possible to specify multiple
distances for the spatial binning of the dates.
}
\examples{
\donttest{
data(neof)
data(centers)
iter <- iterateSites(neof, "C14Age", centers, "Site", binWidths=500)
}
}
