% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{summary.coefspar}
\alias{summary.coefspar}
\title{Summary Method for \code{'coefspar'} Object}
\usage{
\method{summary}{coefspar}(object, digits = 4L, ...)
}
\arguments{
\item{object}{An object of class \code{coefspar}.}

\item{digits}{integer digits to be printed, defaults to 4L.}

\item{...}{Additional arguments (ignored).}
}
\value{
Invisibly returns \code{object}.
}
\description{
Provides a summary of a \code{coefspar} object.
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 2000, ntest = 100)
spar_res <- spareg(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10))
summary(coef(spar_res))
summary(coef(spar_res, aggregate = "none"))
}
