% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkline.R
\name{spk_chr}
\alias{spk_chr}
\title{Character Version of Sparklines}
\usage{
spk_chr(values, ..., width = 60, height = 20, elementId = NULL,
  renderSelector = NULL)
}
\arguments{
\item{values}{\code{vector} of values to visualize}

\item{...}{additional options passed to \code{jquery.sparkline};  see
\href{http://omnipotent.net/jquery.sparkline/#common}{jquery.sparkline docs}}

\item{width}{height and width of sparkline htmlwidget
specified in any valid \code{CSS} size unit.}

\item{height}{height and width of sparkline htmlwidget
specified in any valid \code{CSS} size unit.}

\item{elementId}{\code{string} id as a valid \code{CSS} element id.}

\item{renderSelector}{\code{string} as \code{CSS} selector to render
in a DOM element other than the \code{htmlwidget} container}
}
\description{
Create a character version ofinteractive sparklines
for use with other 'htmlwidgets' or tags.
}
\examples{
\dontrun{
  #spk_chr works well with dplyr summarise
  
  library(dplyr)
  library(sparkline)
  library(formattable)
  
  mtcars \%>\%
    group_by(cyl) \%>\%
    summarise(
      hp = spk_chr(
        hp, type="box",
        chartRangeMin=0, chartRangeMax=max(mtcars$hp)
      ),
      mpg = spk_chr(
        mpg, type="box",
        chartRangeMin=0, chartRangeMax=max(mtcars$mpg)
      )
    ) \%>\%
    formattable() \%>\%
    formattable::as.htmlwidget() \%>\%
    spk_add_deps()
}
}

