% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rda-high-dim.r
\name{rda_high_dim_cv}
\alias{rda_high_dim_cv}
\title{Helper function to optimize the HDRDA classifier via cross-validation}
\usage{
rda_high_dim_cv(
  x,
  y,
  num_folds = 10,
  num_lambda = 21,
  num_gamma = 8,
  shrinkage_type = c("ridge", "convex"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{Matrix or data frame containing the training data. The rows are the
sample observations, and the columns are the features. Only complete data are
retained.}

\item{y}{vector of class labels for each training observation}

\item{num_folds}{the number of cross-validation folds.}

\item{num_lambda}{The number of values of \code{lambda} to consider}

\item{num_gamma}{The number of values of \code{gamma} to consider}

\item{shrinkage_type}{the type of covariance-matrix shrinkage to apply. By
default, a ridge-like shrinkage is applied. If \code{convex} is given, then
shrinkage similar to Friedman (1989) is applied. See Ramey et al. (2017) for
details.}

\item{verbose}{If set to \code{TRUE}, summary information will be outputted
as the optimal model is being determined.}

\item{...}{Options passed to \code{\link[=rda_high_dim]{rda_high_dim()}}.}
}
\value{
list containing the HDRDA model that minimizes cross-validation as
well as a \code{data.frame} that summarizes the cross-validation results.
}
\description{
For a given data set, we apply cross-validation (cv) to select the optimal
HDRDA tuning parameters.
}
\details{
The number of cross-validation folds is given in \code{num_folds}.
}
