% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-cov.r
\name{rda_weights}
\alias{rda_weights}
\title{Computes the observation weights for each class for the HDRDA classifier}
\usage{
rda_weights(x, y, lambda = 1)
}
\arguments{
\item{x}{Matrix or data frame containing the training data. The rows are the
sample observations, and the columns are the features. Only complete data are
retained.}

\item{y}{vector of class labels for each training observation}

\item{lambda}{the RDA pooling parameter. Must be between 0 and 1, inclusively.}
}
\value{
list containing the observations for each class given in \code{y}
}
\description{
This function calculates the weight for each observation in the data matrix
\code{x} in order to calculate the covariance matrices employed in the HDRDA
classifier, implemented in \code{\link[=rda_high_dim]{rda_high_dim()}}.
}
\references{
Ramey, J. A., Stein, C. K., and Young, D. M. (2013),
"High-Dimensional Regularized Discriminant Analysis."
}
