% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm2_kalman_logLik.R
\name{bm2_kalman_logLik}
\alias{bm2_kalman_logLik}
\title{Exact log-likelihood for Brownian motion spatPomp generator
with shared or unit-specific parameters}
\usage{
bm2_kalman_logLik(bm2_object, params = coef(bm2_object))
}
\arguments{
\item{bm2_object}{A spatPomp model built using \code{bm2}.}

\item{params}{A parameter vector at which to evaluate the log-likelihood.
whereas observations occur every one time unit}
}
\value{
A numeric value for the log-likelihood.
}
\description{
Computes the exact likelihood for a model constructed using \code{bm2},
using the Kalman filter. This model is useful for testing methods
for models with unit-specific parameters, or method such as ibpf
which require a unit-specific extension of shared parameters.
}
\examples{
# Further examples are provided in the tests directory
\dontrun{
b <- bm2()
bm2_kalman_logLik(b)
}
}
\author{
Edward L. Ionides
}
