% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_moran.R
\name{get_moran}
\alias{get_moran}
\title{Gets Moran's I test of model residuals}
\usage{
get_moran(model)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}}
}
\value{
A data frame with Moran's I test results produced by \code{\link[=moran_multithreshold]{moran_multithreshold()}}.
}
\description{
Returns the Moran's I test on the residuals of a model produced by \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)
 data(distance_matrix)

 #fitting a random forest model
 rf.model <- rf(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000, 2000),
   n.cores = 1,
   verbose = FALSE
 )

 #getting Moran's I of the residuals
 x <- get_moran(rf.model)

}
}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=moran_multithreshold]{moran_multithreshold()}}, \code{\link[=plot_moran]{plot_moran()}}, \code{\link[=print_moran]{print_moran()}}.
}
