% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialwarnings.R
\docType{package}
\name{spatialwarnings-package}
\alias{spatialwarnings}
\alias{spatialwarnings-package}
\title{Early Spatial-Warnings of Ecosystem Degradation}
\description{
Many dynamical systems such as ecosystems exhibit non-linear responses to 
changes in their external drivers, resulting in possible wide state shifts 
with strong ecological or economical consequences. This often happens when 
a system exhibit a change in its stability properties as a threshold is 
crossed, \emph{e.g.} going from multiple stable states to a single stable 
state. For a few decades, much research has been dedicated to finding a 
way to anticipate these tipping points in ecological systems. This has led 
to the development of indicators, which are metrics based on spatial
structure, that could reflect the proximity of an ecosystem to a tipping
point. 

This package implements many of these indicators, or 
\emph{early-warning signals} (EWS), on spatial raster data. High-level 
functions and methods provide familiar workflows to compute several related
indicators at once, and display their variations along environmental gradients 
or time-series. Lower-level functions are also available to integrate 
early-warning signals into different workflows. 

Main, "workflow" functions provided by this package: 

"Workflow" functions, which may compute several indicators at once:
\itemize{ 
  \item \code{\link{generic_sews}}: Generic spatial EWS
  \item \code{\link{spectral_sews}}: Spectrum-based EWS
  \item \code{\link{patchdistr_sews}}: EWS based on patch-size distributions
  \item \code{\link{kbdm_sews}}: Kolmogorov complexity
  \item \code{\link{flowlength_sews}}: Flow length 
  \item \code{\link{variogram_sews}}: Variogram-based indicators
  \item \code{\link{lsw_sews}}: Indicators based on the Lifshitz-Slyozov-Wagner distribution
}

Individual indicator functions, which may be used to compute raw indicator values 

\itemize{ 
  \item \code{\link{raw_cg_moran}}: lag-1 spatial autocorrelation 
  \item \code{\link{raw_cg_variance}}: Spatial variance
  \item \code{\link{raw_cg_skewness}}: Spatial skewness
  \item \code{\link{raw_sdr}}: Spectral density ratio (SDR)
  \item \code{\link{indicator_psdtype}}: Patch-size distribution shape 
  \item \code{\link{indicator_plrange}}, 
          \code{\link{raw_plrange}} : Power-law range
  \item \code{\link{raw_kbdm}}: Kolmogorov complexity
  \item \code{\link{raw_flowlength_uniform}}: Flow Length
  \item \code{\link{raw_structvar}}: Structural variance
  \item \code{\link{raw_lsw_aicw}}: Support for LSW distribution relative to lognormal
  \item \code{\link{raw_patch_radii_skewness}}: Skewness of patch radii
}

The package homepage is available at 
\href{https://github.com/spatial-ews/spatialwarnings}{Github}
and a  
\href{https://alex.lecairn.org/spatialwarnings-faq.html}{user guide} is 
also available. Do not hesitate to get in touch if you want to make changes to the 
package or add another indicator.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/spatial-ews/spatialwarnings}
  \item Report bugs at \url{https://github.com/spatial-ews/spatialwarnings/issues}
}

}
\author{
\strong{Maintainer}: Alexandre Genin \email{alexandre.genin@sete.cnrs.fr} (\href{https://orcid.org/0000-0002-3333-1338}{ORCID})

Authors:
\itemize{
  \item Alain Danet
  \item Vishwesha Guttal
  \item Sonia Kefi
  \item Sabiha Majumder
  \item Sumithra Sankaran
  \item Florian Schneider
}

}
\keyword{internal}
