% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_range.R
\name{computeS}
\alias{computeS}
\title{Compute Smoothing Matrix}
\usage{
computeS(x, inds = 1:nrow(x))
}
\arguments{
\item{x}{Matrix of spline values, assumed to have full rank. A data frame is coerced into a matrix.}

\item{inds}{Column indices of smoothing matrix to return (corresponding to rows in \code{x}).}
}
\value{
An \eqn{N}-by-\eqn{n} matrix, where \eqn{n} is the length of \code{inds} and \eqn{N} is the number of rows in \code{x}.
}
\description{
Calculates the smoothing (or "hat") matrix from a design matrix.
}
\details{
Given a matrix \code{X} of spline values, this computes  \code{S=X(X'X)^(-1)X'}. When \code{x} has many rows, this can be quite large. The \code{inds} argument can be used to return a subset of columns from \code{S}.
}
\examples{
# Simple design matrix case
X <- cbind(1, rep(c(0, 1), each=4))
S <- computeS(X)
# More complex example
xloc <- runif(n=100, min=0, max=10)
X <- splines::ns(x=xloc, df=4, intercept=TRUE)
S <- computeS(X)
S2 <- computeS(X, inds=1:4)
}
\seealso{
\code{\link{compute_effective_range}}
}
