% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{specify.data.frame}
\alias{specify.data.frame}
\title{Specify Data Frame}
\usage{
\method{specify}{data.frame}(x, spec, na.rm = TRUE, empty.rm = TRUE, ...)
}
\arguments{
\item{x}{data.frame}

\item{spec}{a data spec (or corresponding filepath) to use as source of attributes}

\item{na.rm}{if TRUE, don't assign NA where encountered}

\item{empty.rm}{if TRUE, don't assign empty string where encountered}

\item{...}{passed arguments}
}
\description{
Attach specifics to a data.frame as attributes, including label and guide.
}
\examples{
data(drug)
spec <- specification(drug,tol = 3)
drug \%matches\% spec
drug <- specify(drug,spec)
attributes(drug$HEIGHT)
}
\seealso{
Other specify: 
\code{\link{specify.character}()},
\code{\link{specify}()}
}
\concept{specify}
