% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromato_env16.R
\name{chromato_env16}
\alias{chromato_env16}
\title{Display the multidimensional ecological niche of a species with a species chromatogram.}
\usage{
chromato_env16(z, y, alpha, m, k, order_smth)
}
\arguments{
\item{z}{a matrix with n samples by p environmental variables (i.e. the value of each environmental variable in each sample)}

\item{y}{a vector with the abundance of a species in the n samples}

\item{alpha}{an integer corresponding to the number of category along each environmental variable}

\item{m}{an integer corresponding to the lowest number of samples needed in a category in order to have an estimation of the mean abundance}

\item{k}{an integer corresponding to the percentage of samples with the highest abundance use to estimate the mean abundance of a species in a given category}

\item{order_smth}{an integer corresponding the order of the simple moving average applied along each niche dimension}
}
\value{
chr2 a matrix corresponding to the species chromatogram (alpha categories by p environmental variables)
}
\description{
Display the multidimensional ecological niche of a species as an array of coloured cells (alpha categories by p environmental variables).
}
\examples{
# Load the example datasets
data("data_abundance")
data("environment")
# Characterise and display the ecological niche of a pseudo-species
# `alpha`=50 categories, `m`=1 sample, `k`=5 and `order_smth`=2
sp_chrom_PS1<-chromato_env16(environment,data_abundance[,1],50,1,5,2)
}
