% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variance.r
\name{plot_variance}
\alias{plot_variance}
\title{Plot variance decomposition}
\usage{
plot_variance(model)
}
\arguments{
\item{model}{a multilevel model that captures the variances of the specification curve (based on the data frame resulting from \code{run_specs}).}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated because the new version of specr uses a new analytic framework.
In this framework, you can plot a similar figure simply by using the generic \code{plot()}
function and adding the argument \code{type = "variance"}. This functions creates a simple
barplot that visually displays how much variance in the outcome (e.g., the regression coefficient)
different analytical choices or combinations therefor account for. To use this approach,
one needs to estimate a multilevel model that includes all analytical choices as
grouping variables (see examples and vignettes). This function uses \code{\link[=icc_specs]{icc_specs()}}
to compute the intraclass correlation coefficients (ICCs), which provides the data
basis for the plot (see examples).
}
\examples{
# Step 1: Run spec curve analysis
results <- run_specs(df = example_data,
                     y = c("y1", "y2"),
                     x = c("x1", "x2"),
                     model = c("lm"))

# Step 2: Estimate multilevel model
library(lme4, quietly = TRUE)
model <- lmer(estimate ~ 1 + (1|x)  + (1|y), data = results)

# Step 3: Plot model
plot_variance(model)

}
\seealso{
\code{\link[=icc_specs]{icc_specs()}} to produce a tibble that details the variance decomposition.
}
