% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R
\name{create_synthetic_data}
\alias{create_synthetic_data}
\title{Generates a survival data set for synthetic streaming service subscription data. 
The survival event in this case is a cancellation of the subscription. It is 
given as a function of household income and average number of hours watched 
in the prior month. Users can adjust the level of censoring and variance in 
the data with the supplied parameters or simply call with no parameters for a
default distribution of data.}
\usage{
create_synthetic_data(
  sample_size = 250,
  minimum_income = 5000,
  median_income = 50000,
  income_variance = 10000,
  min_watchhours = 0,
  max_watchhours = 6,
  censor_percentage = 0,
  min_censor_amount = 0,
  max_censor_amount = 0,
  study_time_in_months = 48,
  perturbation_shift = 0
)
}
\arguments{
\item{sample_size}{optional - size of the sample population to generate}

\item{minimum_income}{optional - minimum household income used to generate the distribution}

\item{median_income}{optional - median household income used to generate the distribution}

\item{income_variance}{optional - variance to use when generating the household income distribution}

\item{min_watchhours}{optional - minimum average number of hours watched used to generate the distribution}

\item{max_watchhours}{optional - minimum average number of hours watched used to generate the distribution}

\item{censor_percentage}{optional - percentage of population to artificially censor}

\item{min_censor_amount}{optional - Minimum number of months of censoring to apply to the censored population}

\item{max_censor_amount}{optional - maximum number of months of censoring to apply to the censored population}

\item{study_time_in_months}{optional - observation horizon in months}

\item{perturbation_shift}{optional - defines a boundary for the amount to randomly perturb the formulaic result. Zero for no perturbation}
}
\value{
A survival data set suitable for modeling using spect_train.
}
\description{
Generates a survival data set for synthetic streaming service subscription data. 
The survival event in this case is a cancellation of the subscription. It is 
given as a function of household income and average number of hours watched 
in the prior month. Users can adjust the level of censoring and variance in 
the data with the supplied parameters or simply call with no parameters for a
default distribution of data.
}
\examples{
data <- create_synthetic_data()

}
\author{
Stephen Abrams, \email{stephen.abrams@louisville.edu}
}
\keyword{utilities}
