% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{make_fwhm}
\alias{make_fwhm}
\title{Resample the FWHM to a new set of bands using a gaussian model}
\usage{
make_fwhm(spec, new_bands, new_fwhm = NULL, return_type = "max", k = 3)
}
\arguments{
\item{spec}{spectra object}

\item{new_bands}{band values to resample the spectra to}

\item{new_fwhm}{FWHM for the new bands}

\item{return_type}{either "max" or "old". If "old" (default), it returns the fwhm inferred from the original's spectra bands. If max (default), it returns the max between the new and old fwhm.}

\item{k}{number of unique FHWM to estimate}
}
\value{
FWHM as a numeric vector
}
\description{
Resample the FWHM to a new set of bands using a gaussian model
}
