% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{spfa}
\alias{spfa}
\title{Fitting Semi-parametric Factor Analysis Model}
\usage{
spfa(
  data,
  dimension = rep(0, ncol(data)),
  discrete = rep(FALSE, ncol(data)),
  control = list()
)
}
\arguments{
\item{data}{a matrix that consists of item responses with missing data coded as \code{NA}.}

\item{dimension}{a vector of integers containing indicators of the latent factor. The default is \code{rep(0, ncol(data))} indicating all item load on the same latent factor.}

\item{discrete}{a vector of \code{TRUE} or \code{FALSE} indicating whether the item is discrete. \code{TRUE}: discrete variable. The length of the vector should be the same as the number of columns of the input data.}

\item{control}{a list containing technical parameters for estimation. May be: 
\itemize{
  \item \code{shortpar} a list containing the starting values of spfa model parameters for each item.
  \item  \code{pos} a list containing positivity constraints
   \item  \code{lmbd} a vector of the penalty parameter (lambda). Default value is a vector of 1s. 
   \item \code{n_basis} number of basis. Default is 11. 
   \item  \code{n_quad} number of quadrature points. Default is 21
   \item  \code{maxit_em} the maximum number of iterations for the EM cycles. Default is 500.
   \item \code{maxit_mstep} the maximum number of iterations for the mstep optimizer.
    \item \code{maxit_start} 
    \item \code{tol_em} tolerance for the EM convergence. Default is 1e-4.
    \item \code{tol_mstep} tolerance for the m-step optimizer. Default is 1e-6.
    \item \code{n_thrd} number of cores used for the penalized EM algorithm to run. Default is 1. 
}}
}
\value{
a list including spfa model parameter estimates and marginal log-likelihood.
}
\description{
\code{spfa} fits a unidimensional or two-dimension factor analysis spfa model 
using penalized maximum likelihood estimation. A unidimensional spfa model can
handle discrete response data (i.e., item responses including binary responses
and polytomous responses) or continuous response data (e.g., response time). 
A two-dimensional \code{spfa} model can only handle simple structure model 
with two latent factors load to continuous and discrete response data, respectively.
}
\examples{
 # load item response time data 
 RT <- spfa::simdata[,1:8]
 
 # Fit a unidimensional spfa model with continuous data (Response time)


 \donttest{
spfa_example <- spfa(data = RT, 
       dimension = rep(0, ncol(RT)), 
       discrete = rep(FALSE, ncol(RT)))
       }
 
 # In the spfa pacakge, the output of spfa_example can be directly extracted. 
 # See example code below:
 
 spfa::spfa_example$shortpar
 
 # Visualize the result for item 1 as an example 
 
 plotitem.cont(spfa::spfa_example$par[[1]])
}
\references{
Liu, Y., & Wang, W. (2022). Semiparametric Factor Analysis for Item-Level Response Time Data. \emph{Psychometrika, 87}(2), 666–692. \doi{10.1007/s11336-021-09832-8}

Liu, Y., & Wang, W. (2023). What Can We Learn from a Semiparametric Factor Analysis of Item Responses and Response Time? An Illustration with the PISA 2015 Data. Retrieved from \url{https://arxiv.org/abs/2303.10079}
}
