% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-spherical-spline.R
\name{penalized_linear_spherical_spline}
\alias{penalized_linear_spherical_spline}
\title{Penalized Linear Spherical Spline}
\usage{
penalized_linear_spherical_spline(
  t,
  y,
  initial_control_points = NULL,
  dimension,
  initial_knots,
  lambdas,
  step_size = 1,
  maxiter = 1000,
  epsilon_iter = 0.001,
  jump_eps = 1e-04,
  verbose = FALSE
)
}
\arguments{
\item{t}{A numeric vector representing the time or location.}

\item{y}{A matrix where each row represents a data point on the sphere.}

\item{initial_control_points}{An optional matrix specifying initial control points. Default is NULL.}

\item{dimension}{An integer specifying the dimension of the spline.}

\item{initial_knots}{An optional numeric vector specifying initial knots. Default is NULL.}

\item{lambdas}{A numeric vector specifying the penalization parameters.}

\item{step_size}{A numeric value specifying the step size for optimization. Default is 1.}

\item{maxiter}{An integer specifying the maximum number of iterations. Default is 1000.}

\item{epsilon_iter}{A numeric value specifying the convergence criterion for iterations. Default is 1e-03.}

\item{jump_eps}{A numeric value specifying the threshold for pruning control points based on jump size. Default is 1e-04.}

\item{verbose}{A logical value indicating whether to print progress information. Default is FALSE.}
}
\value{
A list containing the fitted result for each complexity parameter and BIC values for model selection. One might choose the element that corresponds to the minimum BIC values as illustrated in the example.
}
\description{
This function fits a penalized piecewise geodesic curve (linear spherical spline) to the given data.
}
\details{
The goal is to find the optimal piecewise geodesic curve for the given spherical data while controlling model complexity through penalty terms.
This function computes the optimal control points and knots for the given data and returns the fitted result.
Internally, coordinate-wise gradient descent is used to minimize the loss function, and a penalty term is added to control the complexity of the model.
The BIC (Bayesian Information Criterion) value is calculated according to the model's complexity to provide information for model selection.
The function constructs piecewise curves using the piecewise_geodesic function and employs penalty terms to control the complexity of the model by updating control points and knots.
To see how to use the function in practical applications, refer to the README or https://github.com/kybak90/spheresmooth.
}
\examples{
apw_cartesian = spherical_to_cartesian(apw_spherical[, 2:3])
t = apw_spherical[, 1]
dimension = 3
initial_knots = knots_quantile(t, dimension = dimension)
lambda_seq = exp(seq(log(1e-04), log(1), length = 3))
fit = penalized_linear_spherical_spline(t = t, y = apw_cartesian,
                                        dimension = dimension,
                                        initial_knots = initial_knots,
                                        lambdas = lambda_seq)
# choose a curve that minimizes the BIC
best_index = which.min(fit$bic_list)
best_index
# obtained control points for the piecewise geodesic curve
fit[[best_index]]$control_points
}
