% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing.R
\name{compare_smoothing}
\alias{compare_smoothing}
\title{Compare traces with different smoothing options.}
\usage{
compare_smoothing(d, tPath, idx, alphaV = c(0.01, 0.05, 0.1), n = 10)
}
\arguments{
\item{d}{Data matrix}

\item{tPath}{Interpolated tour path (as list of projections)}

\item{idx}{Index function}

\item{alphaV}{Jitter amounts to compare (for jittering angle or points)}

\item{n}{Number of evaluations entering mean value calculation}
}
\value{
Table of mean index values
}
\description{
Compare traces with different smoothing options.
}
\examples{
d <- as.matrix(spiral_data(30, 3))
tPath <- tourr::save_history(d, max_bases=2)
tPath <- as.list(tourr::interpolate(tPath, 0.3))
idx <- scag_index("stringy")
compS <- compare_smoothing(d, tPath, idx, alphaV = c(0.01, 0.05), n=2)
plot_smoothing_comparison(compS)
}
