% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{squint_angle_estimate}
\alias{squint_angle_estimate}
\title{Estimating squint angle of 2-d structure in high-d dataset under selected index.}
\usage{
squint_angle_estimate(
  data,
  indexF,
  cutoff,
  structure_plane,
  n = 100,
  step_size = 0.01
)
}
\arguments{
\item{data}{Input data}

\item{indexF}{Index function}

\item{cutoff}{Threshold index value above which we assume the structure to be visible}

\item{structure_plane}{Plane defining the optimal view}

\item{n}{Number of random starting planes (default = 100)}

\item{step_size}{Interpolation step size fixing the accuracy (default = 0.01)}
}
\value{
numeric vector containing all squint angle estimates
}
\description{
We estimate the squint angle by interpolating from a random starting plane
towards the optimal view until the index value of the selected index function
is above the selected cutoff. Since this depends on the direction, this is repeated
with n randomly selected planes giving a distribution representative of the squint angle.
}
\examples{
data <- spiral_data(50, 4)
indexF <- scag_index("stringy")
cutoff <- 0.7
structure_plane <- basis_matrix(3,4,4)
squint_angle_estimate(data, indexF, cutoff, structure_plane, n=1)
}
