% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evap.R
\name{calc_daily_evap}
\alias{calc_daily_evap}
\title{Calculate daily evaporation fluxes}
\usage{
calc_daily_evap(
  lat,
  n,
  elv = 0,
  y = 0,
  sf = 1,
  tc = 23,
  sw = 1,
  ke = 0.0167,
  keps = 23.44,
  komega = 283,
  kw = 0.26
)
}
\arguments{
\item{lat}{double, decimal degrees.}

\item{n}{double, day of year.}

\item{elv}{double, elevation, m A.S.L.
Default: \eqn{0}.}

\item{y}{double, year.
Default: \eqn{0}.}

\item{sf}{double, fraction of sunshine hours.
Default: \eqn{1}.}

\item{tc}{double, mean daily air temperature, degrees C.
Default: \eqn{23.0}.}

\item{sw}{double, evaporative supply rate, mm/hr.
Default: \eqn{1.0}.}

\item{ke}{double, eccentricity of earth's orbit.
Default: \eqn{0.01670}, 2000CE (Berger, 1978).}

\item{keps}{double, obliquity of earth's elliptic.
Default: \eqn{23.44}, 2000CE (Berger, 1978).}

\item{komega}{double, lon. of perihelion, degrees
Default: \eqn{283}, 2000CE (Berger, 1978).}

\item{kw}{double, PET entrainment, \eqn{(1 + kw) * EET}
Default: \eqn{0.26} (Priestley-Taylor, 1972)}
}
\value{
Returns a \code{list} object with the following variables:
\itemize{
\item nu_deg ............ true anomaly, degrees
\item lambda_deg ........ true longitude, degrees
\item dr ................ distance factor, unitless
\item delta_deg ......... declination angle, degrees
\item hs_deg ............ sunset angle, degrees
\item ra_j.m2 ........... daily extraterrestrial radiation, J/m^2
\item tau ............... atmospheric transmittivity, unitless
\item ppfd_mol.m2 ....... daily photosyn photon flux density, mol/m^2
\item hn_deg ............ net radiation hour angle, degrees
\item rn_j.m2 ........... daily net radiation, J/m^2
\item rnn_j.m2 .......... daily nighttime net radiation, J/m^2
\item econ_m3.j ......... water to energy conversion, m^3/J
\item cond_mm ........... daily condensation, mm
\item eet_mm ............ daily equilibrium evapotranspiration, mm
\item pet_mm ............ daily potential evapotranspiration, mm
\item hi_deg ............ intersection hour angle, degrees
\item aet_mm ............ daily actual evapotranspiration, mm
}
}
\description{
This function calculates daily radiation, condensation, and evaporation
fluxes.
}
\examples{
evap <- splash::calc_daily_evap(lat = 37.7,
                                n = 172,
                                elv = 142,
                                y = 2000,
                                sf = 1,
                                tc = 23.0,
                                sw = 0.9)
cat(sprintf("Evaporation values:\n"))
cat(sprintf("  s: \%0.6f Pa/K\n", evap$s_pa.k))
cat(sprintf("  Lv: \%0.6f MJ/kg\n", (1e-6) * evap$lv_j.kg))
cat(sprintf("  Patm: \%0.6f bar\n", (1e-5) * evap$patm_pa))
cat(sprintf("  pw: \%0.6f kg/m^3\n", evap$pw_kg.m3))
cat(sprintf("  gamma: \%0.6f Pa/K\n", evap$gam_pa.k))
cat(sprintf("  Econ: \%0.6f mm^3/J\n", (1e9) * evap$econ_m3.j))
cat(sprintf("  Cn: \%0.6f mm\n", evap$cond_mm))
cat(sprintf("  rx: \%0.6f\n", evap$rx))
cat(sprintf("  hi: \%0.6f degrees\n", evap$hi_deg))
cat(sprintf("  EET: \%0.6f mm\n", evap$eet_mm))
cat(sprintf("  PET: \%0.6f mm\n", evap$pet_mm))
cat(sprintf("  AET: \%0.6f mm\n", evap$aet_mm))
}
\references{
Berger, A.L., 1978. Long-term variations of daily insolation and Quaternary
climatic changes. Journal of Atmospheric Sciences, 35(12), pp.2362-2367.
\doi{10.1175/1520-0469(1978)035<2362:LTVODI>2.0.CO;2}

Priestley, C.H.B. and Taylor, R.J., 1972. On the assessment of surface heat
flux and evaporation using large-scale parameters. Monthly weather review,
100(2), pp.81-92. \doi{10.1175/1520-0493(1972)100<0081:OTAOSH>2.3.CO;2}
}
