% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glscv.R
\name{glscv}
\alias{glscv}
\title{Cross validation, n-fold and leave-one-out for generalized least squares ('gls')}
\usage{
glscv(
  model = var1 ~ 1,
  trainxy,
  y,
  corr.args = NULL,
  weights = NULL,
  validation = "CV",
  cv.fold = 10,
  predacc = "VEcv",
  ...
)
}
\arguments{
\item{model}{a formula defining the response variable and predictive variables.}

\item{trainxy}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples. That is,
the location information must be names as 'long' and 'lat'.}

\item{y}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{corr.args}{arguments for 'correlation' in 'gls'. See '?corClasses' in 'nlme'
for details. By default, "NULL" is used. When "NULL" is used,
then 'gls' is actually performing 'lm'.}

\item{weights}{describing the within-group heteroscedasticity structure. Defaults
 to "NULL", corresponding to homoscedastic errors. See '?gls' in 'nlme'
for details.}

\item{validation}{validation methods, include 'LOO': leave-one-out, and 'CV':
cross-validation.}

\item{cv.fold}{integer; number of folds in the cross-validation. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{...}{other arguments passed on to 'gls'.}
}
\value{
A list with the following components:
 me, rme, mae, rmae, mse, rmse, rrmse, vecv and e1; or vecv only
}
\description{
This function is a cross validation function for 'gls' method
in 'nlme' package.
}
\note{
This function is largely based on rfcv in 'randomForest' and
'gls' in 'library(nlme)'.
}
\examples{
\donttest{
library(spm)
library(nlme)

data(petrel)
gravel <- petrel[, c(1, 2, 6:9, 5)]
range1 <- 0.8
nugget1 <- 0.5

model <- log(gravel + 1) ~  long + lat +  bathy + dist + I(long^2) + I(lat^2) +
I(lat^3) + I(bathy^2) + I(bathy^3) + I(dist^2) + I(dist^3) + I(relief^2) + I(relief^3)


glscv1 <- glscv(model = model, gravel, log(gravel[, 7] +1), validation = "CV",
 corr.args = corSpher(c(range1, nugget1), form = ~ long + lat, nugget = TRUE),
 predacc = "ALL")
glscv1

#For gls
set.seed(1234)
n <- 20 # number of iterations,60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
glscv1 <- glscv(model = model, gravel, log(gravel[, 7] +1), validation = "CV",
          corr.args = corSpher(c(range1, nugget1), form = ~ long + lat,
          nugget = TRUE), predacc = "VEcv")
VEcv [i] <- glscv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for GLS", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)

# For lm, that is, gls with 'correlation = NULL'
n <- 20 # number of iterations,60 to 100 is recommended.
VEcv <- NULL
set.seed(1234)
for (i in 1:n) {
glscv1 <- glscv(model = model, gravel, log(gravel[, 7] +1),
validation = "CV", predacc = "VEcv")
VEcv [i] <- glscv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for GLS", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)
}

}
\references{
Pinheiro, J. C. and D. M. Bates (2000). Mixed-Effects Models
in S and S-PLUS. New York, Springer.
}
\author{
Jin Li
}
