% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivor.R
\name{residuals.spbp}
\alias{residuals.spbp}
\title{BP based models residuals.}
\usage{
\method{residuals}{spbp}(object, type = c("cox-snell"), ...)
}
\arguments{
\item{object}{an object of class `spbp` result of a \code{\link[spsurv]{spbp}} fit.}

\item{type}{type of residuals, default is "cox-snell"}

\item{...}{further arguments passed to or from other methods}
}
\description{
Residuals for a fitted \code{\link[spsurv]{spbp}} model.
}
\examples{

library("spsurv")
data("veteran")

fit <- bpph(Surv(time, status) ~ karno + factor(celltype),
data = veteran)

residuals(fit)

}
\seealso{
\code{\link[spsurv]{spbp}}.
}
