% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils2.R
\name{stan_dens.spbp}
\alias{stan_dens.spbp}
\title{Density plots method for fitted spbp models}
\usage{
\method{stan_dens}{spbp}(spbp, pars = c("beta", "gamma"), ...)
}
\arguments{
\item{spbp}{the result of a \code{\link[spsurv]{spbp}} fit.}

\item{pars}{parameters to be selected.}

\item{...}{arguments inherent from \code{\link[rstan]{stan_dens}}.}
}
\value{
see \code{\link[rstan]{stan_dens}}.
}
\description{
Posterior density of samples from a fitted \code{\link[spsurv]{spbp}} model.
}
\examples{

library("spsurv")
data("veteran")

fit <- bpph(Surv(time, status) ~ karno + factor(celltype),
data = veteran)

stan_dens(fit)

}
\seealso{
\code{\link[spsurv]{spbp}}, \code{\link[spsurv]{traceplot.spbp}}, \code{\link[spsurv]{extract.spbp}}
}
