#' Update Query.
#'
#' This class represents an SQL UPDATE query.
#' See the make_update() factory function to create more easily an UPDATE query
#' object.
#'
#' @examples
#' # To generate a simple UPDATE query:
#' where <- StmtWhere$new(ExprBinOp$new(
#'   ExprField$new("year"), "<",
#'   ExprValue$new(2010)
#' ))
#' set <- make_set(price = 9.50, old = TRUE)
#' update <- QueryUpdate$new(StmtUpdate$new('books'), set = set)
#' update$add(where)
#'
#' @seealso \code{\link{make_update}}
#' @import R6
#' @include Query.R StmtUpdate.R StmtSet.R
#' @export
QueryUpdate <- R6::R6Class("QueryUpdate",
  inherit = Query,
  public = list(

    #' @description
    #' Initializer.
    #' @param up A StmtUpdate instance.
    #' @param set A StmtSet instance.
    #' @return Nothing.
    initialize = function(up, set) {
      chk::chk_is(up, "StmtUpdate")
      chk::chk_is(set, "StmtSet")
      super$initialize(c("Update", "Set", "Where?"))
      self$add(up)
      self$add(set)
      return(invisible(NULL))
    }
  )
)
