#' Abstract SELECT statement.
#'
#' This is an abstract class representing a SQL SELECT statement. It is
#' inherited by concrete classes `StmtSelectAll` and `StmtSelectFields`.
#'
#' @examples
#' # No example provided, as this class is abstract.
#'
#' @seealso \code{\link{StmtSelectAll}}, \code{\link{StmtSelectFields}}
#' @import R6
#' @include Statement.R
#' @export
StmtSelect <- R6::R6Class("StmtSelect",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer
    #' @param distinct Set to TRUE enable `distinct` keyword and remove
    #'                 duplicate results.
    #' @return Nothing.
    initialize = function(distinct = FALSE) {
      chk::chk_flag(distinct)
      private$distinct <- distinct
      super$initialize()
      return(invisible(NULL))
    }
  ),
  private = list(
    distinct = FALSE
  )
)
