#' TokenIdentifier class.
#'
#' This class represents a SQL identifier token, such as a table or column name.
#'
#' @examples
#' # No example since this class is not exported.
#'
#' @import R6
#' @include Token.R
TokenIdentifier <- R6::R6Class("TokenIdentifier",
  inherit = Token,
  public = list(

    #' @description
    #' Initializer.
    #' @param id The identifier.
    #' @return Nothing.
    initialize = function(id) {
      chk::chk_string(id)
      if (!nzchar(id))
        stop("Identifier cannot be an empty string.", call. = FALSE)
      private$id <- id
      return(invisible(NULL))
    },

    #' @description
    #' Converts into a string.
    #' @return A string containing the SQL expression.
    toString = function() {
      return(quote_ids(private$id))
    }
  ),
  private = list(
    id = NULL
  )
)
