testthat::context("ExprListValues class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprListValues$new())
  testthat::expect_error(ExprListValues$new(TRUE))
  testthat::expect_error(ExprListValues$new("a"))
  ExprListValues$new(list(ExprValue$new("a")))
  ExprListValues$new(list(ExprValue$new("a"), ExprValue$new("b")))
  ExprListValues$new(list(ExprValue$new(10)))
  ExprListValues$new(list(ExprValue$new(10), ExprValue$new(20)))
})

testthat::test_that("Conversion to string works fine", {
  testthat::expect_equal(ExprListValues$new(list())$toString(), "()")
  testthat::expect_equal(
    ExprListValues$new(list(ExprValue$new(10)))$toString(),
    "(10)"
  )
  testthat::expect_equal(
    ExprListValues$new(list(
      ExprValue$new(1),
      ExprValue$new(2)
    ))$toString(),
    "(1, 2)"
  )
  testthat::expect_equal(
    ExprListValues$new(list(ExprValue$new("a")))$toString(),
    "('a')"
  )
  testthat::expect_equal(
    ExprListValues$new(list(
      ExprValue$new("a"),
      ExprValue$new("b")
    ))$toString(),
    "('a', 'b')"
  )
})

testthat::test_that("make_values() factory works fine", {
  testthat::expect_error(make_values(list(1,"a")))
  x <- make_values(c(1,2,3))
  testthat::expect_equal(x$toString(), "(1, 2, 3)")
})
