% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/increasing_search.R
\name{increasing_search}
\alias{increasing_search}
\title{Increasing Embedding Search engine, used by get/plot increasing_search}
\usage{
increasing_search(
  predictors,
  target,
  plot = TRUE,
  caption = "",
  show = "Gamma"
)
}
\arguments{
\item{predictors}{A vector or matrix whose columns are proposed inputs to a
predictive function}

\item{target}{A vector of double, the output variable that is to be predicted}

\item{plot}{Logical, set plot = FALSE if you don't want the plot}

\item{caption}{Character string to identify plot, for example, data being plotted}

\item{show}{Character string, if it equals "vratio", vratios will be plotted,
otherwise Gamma is plotted}
}
\value{
An invisible data frame with three columns, Depth of search, from
1 to ncol(predictors), Gamma calculated using columns 1:Depth as predictors,
and vratio corresponding to that Gamma (Gamma / var(target))
}
\description{
Adds variables one at a time to the input set, to see how many are needed for prediction.
}
\details{
An increasing embedding search is appropriate when the input variables are ordered,
most commonly in analyzing time series, when it's useful to know how many previous
time steps or lags should be examined to build a model.  Starting with lag 1, the
search adds previous values one at a time, and saves the resulting gammas.  These
results can be examined using plot_increasing_search()
}
\examples{
he <- embed(henon_x, 13)
t <- he[ , 1]
p <- he[ ,2:13]
increasing_search(p, t, caption = "henon data embedded 16")
df <- increasing_search(predictors=p, target=t, plot = FALSE)
}
