% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sic_l.R
\name{sic.l}
\alias{sic.l}
\title{Optimisation of the (simpler) Smooth-Rough Partition model}
\usage{
sic.l(x.basis = x.basis, M.basis = M.basis, x = x, y = y,
  cf0 = cf0, maxq = maxq, fixedq = F)
}
\arguments{
\item{x.basis}{The b-spline basis defined for interpolated x in \code{\link{srp.l}}.}

\item{M.basis}{The monomial basis defined for constrained regression coefficient.}

\item{x}{The design matrix used in \code{\link{srp.l}}.}

\item{y}{The response variable used in \code{\link{srp.l}}.}

\item{cf0}{The coefficient matrix obtained by natural cubic spline interpolation of x in \code{\link{ncs}}.}

\item{maxq}{The maximum number of unconstrained parameters if \code{fixedq} is FALSE. Otherwise, it is considered as a unique number of unconstrained parameters.}

\item{fixedq}{If TRUE, \code{maxq} is considered as a fixed number of unconstrained parameters and if FALSE, \code{maxq} is a maximum and a sequence of possible values are investigated to select the optimal.}
}
\value{
The following components are obtained only when \code{fixedq} is FALSE:
\item{qhat}{The optimal number of unconstrained parameters.}
\item{sicq}{The vector of Schwarz criterion with length \code{maxq} which is computed for the different number of unconstrained parameters.} The following components are obtained only when \code{fixedq} is TRUE:
\item{muhat}{The estimator of constant parameter.}
\item{bhat}{The vector of evaluated constrained functional regression coefficient.}
\item{ahat}{The vector of unconstrained regression coefficient estimators.}
\item{etahat}{The vector containing both \code{bhat} and \code{ahat} with unevaluated form.}
\item{yhat}{The vector of estimated response variable.}
}
\description{
This function performs the optimisation of the number of unconstrained regression parameters in (simpler) Smooth-Rough Partition model by minimising SIC criterion and gives the change-point in regression parameters.
}
\details{
Usually only called by \code{\link{srp.l}}.
}
\examples{
library(fda)
x <- matrix(rnorm(10000), ncol=100)
y <- matrix(rnorm(100), ncol=1)
p <- dim(x)[1] + 1
t <- seq(0, 1, length.out=dim(x)[1])*(dim(x)[1])
x.basis <- as.fd(splinefun(t, x[, 1], method="natural"))$basis
M.basis <- create.monomial.basis(rangeval=c(0, dim(x)[1]), nbasis=2)
result <- sic.l(x.basis=x.basis, M.basis=M.basis, x=x, y=y, cf0=ncs(x)$cf0, maxq=10)
plot(result$sicq, type="b")
}
\seealso{
\code{\link{sic.c}}, \code{\link{srp.l}}
}
\author{
Hyeyoung Maeng, \email{h.maeng@lse.ac.uk}
}
