% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_D.R
\name{compute_D}
\alias{compute_D}
\title{Compute the matrix of distances D for kappa parameters}
\usage{
compute_D(Y = NULL, y_T = pi/4, y_D = (3 * pi)/4)
}
\arguments{
\item{Y}{(matrix) N x JI matrix of observed trajectories}

\item{y_T}{(numeric) position in angles of the target}

\item{y_D}{(numeric) position in angles of the distractor}
}
\value{
a N x JI matrix containing the delta values for each data point in Y
}
\description{
Compute the matrix of distances D for kappa parameters
}
\details{
The function compute the distance of the Y-trajectories from the distractor and target points. This is an internal function, generally not to be called by the user.
}
\examples{

## Generate a generic matrix Y of I = 5 individuals and J = 1 trajectories (N = 61)
I <- 5; N <- 61
y_T <- pi/4; y_D <- (3*pi)/4
Y <- matrix(stats::rnorm(n = N*I,mean = (y_T+y_D)/2,sd = 10),N,I)
DY <- compute_D(Y=Y,y_T=y_T,y_D=y_D)

}
