% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fitdists}
\alias{predict.fitdists}
\title{Predict Hazard Concentrations of fitdists Object}
\usage{
\method{predict}{fitdists}(
  object,
  percent,
  proportion = 1:99/100,
  ...,
  average = TRUE,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  est_method = "multi",
  ci_method = "weighted_samples",
  parametric = TRUE,
  delta = 9.21,
  control = NULL
)
}
\arguments{
\item{object}{The object.}

\item{percent}{A numeric vector of percent values to estimate hazard concentrations for. Deprecated for \code{proportion = 0.05}. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{proportion}{A numeric vector of proportion values to estimate hazard concentrations for.}

\item{...}{Unused.}

\item{average}{A flag specifying whether to provide model averaged values as opposed to a value for each distribution.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{est_method}{A string specifying whether to estimate directly from
the model-averaged cumulative distribution function (\code{est_method = 'multi'}) or
to take the arithmetic mean of the estimates from the
individual cumulative distribution functions weighted
by the AICc derived weights  (\code{est_method = 'arithmetic'}) or
or to use the geometric mean instead (\code{est_method = 'geometric'}).}

\item{ci_method}{A string specifying which method to use for estimating
the standard error and confidence limits from the bootstrap samples.
Possible values include \code{ci_method = "multi_fixed"} and  \code{ci_method = "multi_free"}
which generate the bootstrap samples using the model-averaged cumulative distribution function
but differ in whether the model weights are fixed at the values for the original dataset
or re-estimated for each bootstrap sample dataset.
The value \code{ci_method = "weighted_samples"} takes bootstrap samples
from each distribution proportional to its AICc based weights and
calculates the confidence limits (and SE) from this single set.
The value \code{ci_method = "MACL"} (was \code{ci_method = "weighted_arithmetic"} but
has been soft-deprecated) which is only included for
historical reasons takes the weighted arithmetic mean of the confidence
limits.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\description{
A wrapper on \code{\link[=ssd_hc]{ssd_hc()}} that by default calculates
all hazard concentrations from 1 to 99\%.
}
\details{
It is useful for plotting purposes.
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
predict(fits)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}} and \code{\link[=ssd_plot]{ssd_plot()}}
}
