% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttkveloc.R
\name{sttkveloc}
\alias{sttkveloc}
\title{Velocity of a Center-of-pressure displacement}
\usage{
sttkveloc(dados, fs)
}
\arguments{
\item{dados}{Data frame with two columns "x" and "y"}

\item{fs}{The sampling frequency used in data recording}
}
\value{
The velocity of the COP displacement \code{sttkveloc}.
}
\description{
Computes the mean velocity of a given Center-of-pressure displacement in the horizontal plane.
}
\details{
'dados' is a data frame containing two columns named "x" and "y".    The pairs (x, y) are the coordinates of the center-of-pressure acquired in a period of time.
}
\examples{
x <- c(1,3,7,5,9,4,3,6,8,2,8,9,4,5,7,3,4,7,9,3,2,5,3,4,8,2,9,7,4,2)
y <- c(6,3,9,1,3,7,4,9,6,1,7,3,9,7,2,6,3,4,8,1,9,3,6,8,1,6,2,9,8,3)

COP <- data.frame(x, y)
fs <- 50

COPvelocity <- sttkveloc(COP,fs)


}
\seealso{
\code{\link[stabilo]{sttkangle}}, \code{\link[stabilo]{sttkellipseplot}}
}
\author{
Jose Magalhaes de Oliveira
}
