% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_functions.R
\name{named_contr_sum}
\alias{named_contr_sum}
\title{Create named sum contrasts for an unordered factor.}
\usage{
named_contr_sum(x, scale = 1, return_contr = TRUE)
}
\arguments{
\item{x}{An object coercible to factor or a numeric or character vector of
levels.}

\item{scale}{A positive number by which the entire contrast
matrix returned by \code{\link[stats]{contr.sum}} is multiplied.  See
'Details'.}

\item{return_contr}{A logical. If \code{TRUE} (the default), a contrast
matrix is returned. If \code{FALSE}, \code{x} is converted to an unordered
factor with the contrast matrix applied, and the factor is returned.}
}
\value{
If \code{return_contr = TRUE}, a contrast matrix obtained from
  \code{\link[stats]{contr.sum}} with named columns rather than numbered
  columns and deviations with magnitude \code{scale}.
  If \code{return_contr = FALSE}, then \code{x} is returned
  as an unordered factor with the named sum contrasts applied.
}
\description{
\code{named_contr_sum} creates sum contrasts for a factor which are named
with the levels of the factor rather than with numbers (e.g. if a factor
\code{f1} has levels \code{A}, \code{B}, and \code{C}, then rather than
creating contrast columns \code{f11} and \code{f12}, it creates columns
\code{f1A} and \code{f1B}).  The absolute value of the non-zero elements
of the matrix can also be specified.
}
\details{
First, \code{x} is coerced to factor, and its levels (excluding \code{NA})
are sorted alphabetically.  If there are two unique values, and they are
equal to (ignoring case) "F" and "T", "FALSE" and "TRUE", "N" and "Y",
"NO" and "YES", or "0" and "1", then their order is reversed (this makes it
so the positive level gets the dummy coefficient rather than the negative
level, yielding a more intuitive interpretation for coefficients).  Then
\code{\link[stats]{contr.sum}} is called, and the column names of the
resulting contrast matrix are set using the character vector of unique values
(excluding the final element that gets coded as \code{-1} for all dummy
variables).  This entire matrix is then multiplied by \code{scale}; with
the default value of \code{1}, this does not change the matrix; if, for
example, \code{scale = 0.5}, then rather than each column containing values
in \code{-1, 0, 1}, each column would contain values in \code{-0.5, 0, 0.5}.
If \code{return_contr = TRUE}, then this contrast matrix is
returned.  If \code{return_contr = FALSE}, then \code{x} is converted to an
unordered factor with the named sum contrasts and returned. \code{NA} is never
assigned as a level in the contrast matrix or in the factor returned by the
function, but \code{NA} values in \code{x} are not removed in the factor
returned when \code{return_contr = FALSE}. See the examples.
}
\examples{
f <- factor(rep(c("a", "b", "c", NA), 2), levels = c("b", "c", "a"))
f <- addNA(f)
levels(f)  # NA listed as factor level
contrasts(f)  # NA included in contrast matrix
named_contr_sum(f)  # named sum contrasts (NA dropped; levels alphabetized)
named_contr_sum(levels(f))  # same output
named_contr_sum(f, return_contr = FALSE)  # factor with named sum contrasts
named_contr_sum(f, 0.5)  # deviations of magniude 0.5

f <- c(TRUE, FALSE, FALSE, TRUE)
class(f)  # logical
named_contr_sum(f)  # TRUE gets the dummy variable
f <- named_contr_sum(f, return_contr = FALSE)
class(f)  # factor

named_contr_sum(letters[1:5])  # character argument
named_contr_sum(rep(letters[1:5], 2), return_contr = FALSE)  # creates factor

# ordered factors are converted to unordered factors, so use with caution
f <- factor(rep(1:3, 2), ordered = TRUE)
is.ordered(f)  # TRUE
f
f <- named_contr_sum(f, return_contr = FALSE)
is.ordered(f)  # FALSE
f

\dontrun{
# error from stats::contr.sum because only one unique non-NA value
named_contr_sum(5)
named_contr_sum(rep(c("a", NA), 3))
}
}
\seealso{
\code{\link{scaled_contr_poly}} for ordered factors.
}
\author{
Christopher D. Eager <eager.stats@gmail.com>
}
