
rpy_db <- new.env(parent = emptyenv())

rpy <- function(key, value) {
    if (missing(value)) {
        rpy_db[[key]]
    } else {
        rpy_db[[key]] <- value
    }
}


#' Options
#'
#' Allow the user to set and examine options like 
#' @param option any options can be defined, using 'key, value' pairs.
#'   If 'value' is missing the current set value is returned for the given 'option'.
#'   If both are missing. all set options are returned.
#' @param value the corresponding value to set for the given option.
#' @param update_python_defaults a logical (default is \code{FALSE}) controling if the corresponding
#'        \pkg{stanza} variables should also updated in \verb{Python}.
#' 
#' @returns 
#' \itemize{
#'  \item \code{NULL} if both arguments \code{option} and \code{value} are provided.
#'  \item The currently set value if the argument \code{value} is missing.
#'  \item All set options if the argument \code{option} is missing.
#' }
#' 
#' @examples
#' stanza_options("conda_environment", "stanza")
#' 
#' @export
stanza_options <-
local({
    options <- list()
    function(option, value, update_python_defaults = FALSE) {
        if (missing(option)) {
            return(options)
        }
        if (missing(value)) {
            options[[option]]
        } else {
            options[[option]] <<- value
            if (isTRUE(options[["initialized"]]) & isTRUE(update_python_defaults)) {
                if (isTRUE(option == "model_dir")) {
                    stanza$resources$common$DEFAULT_MODEL_DIR <- value
                } else if (isTRUE(option == "resources_url")) {
                    stanza$resources$common$DEFAULT_RESOURCES_URL <- value
                } else if (isTRUE(option == "resources_version")) {
                    stanza$resources$common$DEFAULT_RESOURCES_VERSION <- value
                } else if (isTRUE(option == "model_url")) {
                    stanza$resources$common$DEFAULT_MODEL_URL <- value
                }
            }
        }
    }
})


#
# testing_levels = c("minimal" = 1L, default" = 2L, "download" = 3L, "install" = 4L, "all" = 5L)
#
.onLoad <- function(libname, pkgname) {
    stanza_options("initialized", NULL)
    env <- getNamespace("stanza")
    makeActiveBinding("stanza", function() rpy("stanza"), env)
    makeActiveBinding("rstanza", function() rpy("rstanza"), env)
    stanza_options("testing_level", as.integer(Sys.getenv("STANZA_TESTING_LEVEL", 2)))
}

