% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footprints.R
\name{footprints}
\alias{footprints}
\title{Footprints}
\usage{
footprints(x)
}
\arguments{
\item{x}{A \code{character} vector of raster file paths}
}
\value{
An \code{sf} layer with the footprints (i.e., bounding box polygons) of the rasters
}
\description{
Calculates a polygon layer with the footprints of raster images.
}
\examples{

# Create sample files
file1 = tempfile(fileext = ".tif")
file2 = tempfile(fileext = ".tif")
file3 = tempfile(fileext = ".tif")
r1 = landsat[,1:100, 1:100,]
r2 = landsat[,101:200, 101:200,]
r3 = landsat[,21:40, 51:120,]
write_stars(r1, file1)
write_stars(r2, file2)
write_stars(r3, file3)

# Calculate footprints
files = c(file1, file2, file3)
pol = footprints(files)
pol

}
