% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vlstarpred.R
\name{plot.vlstarpred}
\alias{plot.vlstarpred}
\title{Plot methods for a vlstarpred object}
\usage{
\method{plot}{vlstarpred}(
  x,
  type = c("single", "multiple"),
  names = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  lty.obs = 2,
  lty.pred = 1,
  lty.ci = 3,
  lty.vline = 1,
  lwd.obs = 1,
  lwd.pred = 1,
  lwd.ci = 1,
  lwd.vline = 1,
  col.obs = NULL,
  col.pred = NULL,
  col.ci = NULL,
  col.vline = NULL,
  ylim = NULL,
  mar = par("mar"),
  oma = par("oma"),
  ...
)
}
\arguments{
\item{x}{An object of class \sQuote{\code{vlstarpred}}.}

\item{type}{Character, if \code{multiple} all plots are drawn in a single device, otherwise the plots are shown consecutively.}

\item{names}{Character vector, the variables names to be plotted. If left \code{NULL}, all variables are plotted.}

\item{main}{Character vector, the titles of the plot.}

\item{xlab}{Character vector signifying the labels for the x-axis.}

\item{ylab}{Character vector signifying the labels for the y-axis.}

\item{lty.obs}{Vector, lty for the plot of the observed values.}

\item{lty.pred}{Vector, lty for the plot of the predicted values.}

\item{lty.ci}{Vector, lty for the interval forecast.}

\item{lty.vline}{Vector, lty for the vertical line.}

\item{lwd.obs}{Vector, lwd for the plot of the observed values.}

\item{lwd.pred}{Vector, lwd for the plot of the predicted values.}

\item{lwd.ci}{Vector, lwd for the interval forecast.}

\item{lwd.vline}{Vector, lwd for the vertical line.}

\item{col.obs}{Character vector, colors for the observed values.}

\item{col.pred}{Character vector, colors for the predicted values.}

\item{col.ci}{Character vector, colors for the interval forecast.}

\item{col.vline}{Character vector, colors for the vertical line.}

\item{ylim}{Vector, the limits of the y-axis.}

\item{mar}{Setting of margins.}

\item{oma}{Setting of outer margins.}

\item{\dots}{Passed to internal plot function.}
}
\value{
Plot of predictions from VLSTAR with their prediction interval
}
\description{
Plot method for objects with class attribute \code{vlstarpred}.
}
\seealso{
\code{\link{predict.VLSTAR}}
}
\author{
Andrea Bucci
}
