% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectSingleOut.R
\name{removeSingleOut}
\alias{removeSingleOut}
\title{Replace outliers for single observations by NA}
\usage{
removeSingleOut(TP, singleOut, trait = attr(x = singleOut, which = "trait"))
}
\arguments{
\item{TP}{An object of class TP.}

\item{singleOut}{A data.frame with at least the columns plotId and
timePoint with values corresponding to those in TP. If a column outlier is
present, as in the output of \code{detectSingleOut}, only plotId x
timePoint combinations for which outlier = 1 will be set to NA. If no
column outlier is present, all observations in singleOut will be set to NA.}

\item{trait}{The trait that should be set to NA. Can be ignored when using
the output of \code{detectSingleOut} as input.}
}
\value{
An object of class TP, the input with the outlier replaced by NA.
}
\description{
Function for replacing outliers for single observations by NA.
}
\examples{
## Create a TP object containing the data from the Phenovator.
PhenovatorDat1 <- PhenovatorDat1[!PhenovatorDat1$pos \%in\%
                                 c("c24r41", "c7r18", "c7r49"), ]
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## First select a subset of plants, for example here 9 plants.
plantSel <- phenoTP[[1]]$plotId[1:9]
# Then run on the subset
resuVatorHTP <- detectSingleOut(TP = phenoTP,
                                trait = "EffpsII",
                                plotIds = plantSel,
                                confIntSize = 3,
                                nnLocfit = 0.1)

## Replace the studied trait by NA for the plants marked as outliers.
phenoTPOut <- removeSingleOut(phenoTP, resuVatorHTP)

}
\seealso{
Other functions for detecting outliers for single observations: 
\code{\link{detectSingleOut}()},
\code{\link{detectSingleOutMaize}()},
\code{\link{plot.singleOut}()}
}
\concept{functions for detecting outliers for single observations}
