% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backTransPCA.r
\name{backTransPCA}
\alias{backTransPCA}
\title{"Back-transform" PCA scores to their original values}
\usage{
backTransPCA(pca, x = NULL)
}
\arguments{
\item{pca}{Object of class \code{prcomp}.}

\item{x}{Either \code{NULL} (default) or a vector of PC scores. If \code{NULL}, then the scores from the PCA object are used.}
}
\value{
Numeric vector.
}
\description{
This function back-transforms principal component scores to their original values.
}
\examples{
x <- data.frame(
	x1 = 1:20 + rnorm(20),
	x2 = 1:20 + rnorm(20, 0, 5),
	x3 = sample(20, 20)
)

pca1 <- prcomp(x, center=FALSE, scale=FALSE)
pca2 <- prcomp(x, center=TRUE, scale=FALSE)
pca3 <- prcomp(x, center=TRUE, scale=TRUE)

backTransPCA(pca1)
backTransPCA(pca2)
backTransPCA(pca3)

}
