% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psum.r
\name{psum}
\alias{psum}
\title{Element-by-element sum}
\usage{
psum(..., na.rm = FALSE)
}
\arguments{
\item{...}{A set of vectors of the same length, a \code{matrix}, or a \code{data.table}.}

\item{na.rm}{If \code{FALSE} (default), return \code{NA} if any element in a set is \code{NA}.}
}
\value{
A numeric vector.
}
\description{
This function is similar to \code{\link{pmax}} or \code{\link{pmin}}, except that it returns the element-wise sum of values. If the input is a \code{matrix} or \code{data.frame}, the output is the same as \code{\link{colSums}}.
}
\details{
Adapted from answer by Ben Bolker on \href{https://stackoverflow.com/questions/13123638/there-is-pmin-and-pmax-each-taking-na-rm-why-no-psum}{StackOverflow}.
}
\examples{

x1 <- 1:10
x2 <- runif(10)
psum(x1, x2)

x <- cbind(x1, x2)
psum(x)

x2[3] <- NA
psum(x1, x2)
psum(x1, x2, na.rm=TRUE)

}
