% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompScoreTable.R
\docType{class}
\name{CompScoreTable}
\alias{CompScoreTable}
\title{R6 class for producing easily re-computable ScoreTable}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Computable ScoreTable class. It can compute and store \code{\link{ScoreTable}s}
for multiple variables containing raw score results.

After computation, it could be also used to compute new standardized scores
for provided raw scores and integrate them into stored tables.

\code{summary()} function can be used to get general information about
\code{CompScoreTable} object.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{CompScoreTable$new()}}
\item \href{#method-attach_StandardScale}{\code{CompScoreTable$attach_StandardScale()}}
\item \href{#method-attach_FrequencyTable}{\code{CompScoreTable$attach_FrequencyTable()}}
\item \href{#method-export_ScoreTable}{\code{CompScoreTable$export_ScoreTable()}}
\item \href{#method-standardize}{\code{CompScoreTable$standardize()}}
\item \href{#method-clone}{\code{CompScoreTable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{CompScoreTable} object. You can attach one or many
\code{StandardScale} and \code{FrequencyTable} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$new(tables = NULL, scales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tables}}{Named list of \code{FrequencyTable} objects to be attached. Names
will indicate the name of variable for which the table is calculated.
Defaults to \code{NULL}, so no tables will be available at the beginning.}

\item{\code{scales}}{\code{StandardScale} object or list of such objects to be attached.
They will be used for calculation of \code{ScoreTables.} Defaults to \code{NULL}, so no
scales wil be available at the beginning.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Both \code{FrequencyTable} and \code{StandardScale} objects can be attached
with appropriate methods after object initialization.
}

\subsection{Returns}{
CompScoreTable object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-attach_StandardScale"></a>}}
\if{latex}{\out{\hypertarget{method-attach_StandardScale}{}}}
\subsection{Method \code{attach_StandardScale()}}{
Attach new scale to the object. If there are any ScoreTables
already computed, score for newly-attached scale will be computed automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$attach_StandardScale(scale, overwrite = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{\code{StandardScale} object defining a scale}

\item{\code{overwrite}}{boolean indicating if the definition for a scale
of the same name should be overwritten}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-attach_FrequencyTable"></a>}}
\if{latex}{\out{\hypertarget{method-attach_FrequencyTable}{}}}
\subsection{Method \code{attach_FrequencyTable()}}{
Attach previously generated \code{FrequencyTable} for a given
variable. \code{ScoreTable} containing every attached scale will be calulcated
automatically based on every new \code{FrequencyTable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$attach_FrequencyTable(
  ft,
  var,
  if_exists = c("stop", "append", "replace")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ft}}{FrequencyTable to be attached}

\item{\code{var}}{String with the name of the variable}

\item{\code{if_exists}}{Action that should be taken if \code{FrequencyTable} for
given variable already exists in the object.
\itemize{
\item \code{stop} DEFAULT: don't do anything
\item \code{append} recalculates existing table
\item \code{replace} replaces existing table
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-export_ScoreTable"></a>}}
\if{latex}{\out{\hypertarget{method-export_ScoreTable}{}}}
\subsection{Method \code{export_ScoreTable()}}{
Export list of \code{ScoreTables} from the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$export_ScoreTable(vars = NULL, strip = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vars}}{Names of the variables for which to get the tables.
If left at \code{NULL} default - get all off them.}

\item{\code{strip}}{logical indicating if the \code{ScoreTables} should be stripped
down to \code{FrequencyTables} during export. Defaults to \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of \code{ScoreTable} or \code{FrequencyTable} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-standardize"></a>}}
\if{latex}{\out{\hypertarget{method-standardize}{}}}
\subsection{Method \code{standardize()}}{
Compute standardize scores for \code{data.frame} of raw scores.
Additionally, the raw scores can be used to recalculate ScoreTables
before computing (using \code{calc = T}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$standardize(data, what, vars = names(data), calc = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame containing raw scores.}

\item{\code{what}}{the values to get. One of either:
\itemize{
\item \code{quan} - the quantile of raw score in the distribution
\item \code{Z} - normalized Z score for the raw scores
\item name of the scale attached to the \code{CompScoreTable} object
}}

\item{\code{vars}}{vector of variable names which will taken into account}

\item{\code{calc}}{should the \code{ScoreTables} be computed (or recalculated, if
some are already provided?). Default to \code{TRUE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.frame} with standardized values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompScoreTable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
